/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.blocks.wood.BlockBarrel;
import net.dries007.tfc.objects.fluids.capability.FluidHandlerSided;
import net.dries007.tfc.objects.fluids.capability.FluidTankCallback;
import net.dries007.tfc.objects.fluids.capability.IFluidHandlerSidedCallback;
import net.dries007.tfc.objects.fluids.capability.IFluidTankCallback;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.dries007.tfc.objects.inventory.capability.ItemHandlerSidedWrapper;
import net.dries007.tfc.objects.items.itemblock.ItemBlockBarrel;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.FluidTransferHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
public class TEBarrel
extends TETickableInventory
implements ITickable,
ICalendarTickable,
IItemHandlerSidedCallback,
IFluidHandlerSidedCallback,
IFluidTankCallback {
    public static final int SLOT_FLUID_CONTAINER_IN = 0;
    public static final int SLOT_FLUID_CONTAINER_OUT = 1;
    public static final int SLOT_ITEM = 2;
    public static final int BARREL_MAX_FLUID_TEMPERATURE = 500;
    private final FluidTank tank = new BarrelFluidTank(this, 0);
    private final Queue<ItemStack> surplus = new LinkedList<ItemStack>();
    private boolean sealed;
    private long sealedTick;
    private long sealedCalendarTick;
    private long lastPlayerTick;
    private BarrelRecipe recipe;
    private int tickCounter;
    private boolean checkInstantRecipe = false;

    public TEBarrel() {
        super(3);
    }

    public void saveToItemStack(ItemStack stack) {
        IFluidHandler barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (barrelCap instanceof ItemBlockBarrel.ItemBarrelFluidHandler) {
            FluidStack storing;
            NBTTagCompound inventoryTag = null;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                inventoryTag = this.inventory.serializeNBT();
                break;
            }
            NBTTagList surplusTag = null;
            if (!this.surplus.isEmpty()) {
                surplusTag = new NBTTagList();
                for (ItemStack surplusStack : this.surplus) {
                    surplusTag.func_74742_a((NBTBase)surplusStack.serializeNBT());
                }
            }
            if ((storing = this.tank.getFluid()) != null || inventoryTag != null || surplusTag != null) {
                ((ItemBlockBarrel.ItemBarrelFluidHandler)barrelCap).setBarrelContents(storing, inventoryTag, surplusTag, this.sealedTick, this.sealedCalendarTick);
            }
        }
    }

    public void loadFromItemStack(ItemStack stack) {
        NBTTagCompound contents;
        IFluidHandler barrelCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (barrelCap instanceof ItemBlockBarrel.ItemBarrelFluidHandler && (contents = ((ItemBlockBarrel.ItemBarrelFluidHandler)barrelCap).getBarrelContents()) != null) {
            this.inventory.deserializeNBT(contents.func_74775_l("inventory"));
            this.surplus.clear();
            NBTTagList surplusItems = contents.func_150295_c("surplus", 10);
            if (!surplusItems.func_82582_d()) {
                for (int i = 0; i < surplusItems.func_74745_c(); ++i) {
                    this.surplus.add(new ItemStack(surplusItems.func_150305_b(i)));
                }
            }
            this.sealedTick = contents.func_74763_f("sealedTick");
            this.sealedCalendarTick = contents.func_74763_f("sealedCalendarTick");
            this.tank.fill(((ItemBlockBarrel.ItemBarrelFluidHandler)barrelCap).getFluid(), true);
            this.sealed = true;
            this.recipe = BarrelRecipe.get(this.inventory.getStackInSlot(2), this.tank.getFluid());
            this.markForSync();
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.sealed = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBarrel.SEALED);
            this.recipe = BarrelRecipe.get(this.inventory.getStackInSlot(2), this.tank.getFluid());
        }
    }

    @Nullable
    public BarrelRecipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public String getSealedDate() {
        return ICalendarFormatted.getTimeAndDate(this.sealedCalendarTick, CalendarTFC.CALENDAR_TIME.getDaysInMonth());
    }

    @Override
    public void setAndUpdateFluidTank(int fluidTankID) {
        this.markForSync();
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack, EnumFacing side) {
        return !this.sealed && (this.isItemValid(slot, stack) || side == null && slot == 1);
    }

    @Override
    public boolean canExtract(int slot, EnumFacing side) {
        return !this.sealed && (side == null || slot != 0);
    }

    @Override
    public boolean canFill(FluidStack resource, EnumFacing side) {
        return !this.sealed && (resource.getFluid() == null || resource.getFluid().getTemperature(resource) < 500);
    }

    @Override
    public boolean canDrain(EnumFacing side) {
        return !this.sealed;
    }

    public void onSealed() {
        if (!this.field_145850_b.field_72995_K) {
            for (int slot : new int[]{0, 1}) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(slot));
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
        this.sealedTick = CalendarTFC.PLAYER_TIME.getTicks();
        this.sealedCalendarTick = CalendarTFC.CALENDAR_TIME.getTicks();
        this.recipe = BarrelRecipe.get(this.inventory.getStackInSlot(2), this.tank.getFluid());
        if (this.recipe != null) {
            this.recipe.onBarrelSealed(this.tank.getFluid(), this.inventory.getStackInSlot(2));
        }
        this.sealed = true;
        this.markForSync();
    }

    public void onUnseal() {
        this.sealedCalendarTick = 0L;
        this.sealedTick = 0L;
        if (this.recipe != null) {
            ItemStack inputStack = this.inventory.getStackInSlot(2);
            FluidStack inputFluid = this.tank.getFluid();
            if (this.recipe.isValidInput(inputFluid, inputStack)) {
                this.tank.setFluid(this.recipe.getOutputFluidOnUnseal(inputFluid, inputStack));
                List<ItemStack> output = this.recipe.getOutputItemOnUnseal(inputFluid, inputStack);
                ItemStack first = output.get(0);
                output.remove(0);
                this.inventory.setStackInSlot(2, first);
                this.surplus.addAll(output);
            }
        }
        this.recipe = null;
        this.sealed = false;
        this.markForSync();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.checkForCalendarUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack first;
            List<ItemStack> output;
            ++this.tickCounter;
            if (this.tickCounter == 10) {
                this.tickCounter = 0;
                ItemStack fluidContainerIn = this.inventory.getStackInSlot(0);
                FluidActionResult result = FluidTransferHelper.emptyContainerIntoTank(fluidContainerIn, (IFluidHandler)this.tank, (IItemHandler)this.inventory, 1, ConfigTFC.Devices.BARREL.tank, this.field_145850_b, this.field_174879_c);
                if (!result.isSuccess()) {
                    result = FluidTransferHelper.fillContainerFromTank(fluidContainerIn, (IFluidHandler)this.tank, (IItemHandler)this.inventory, 1, ConfigTFC.Devices.BARREL.tank, this.field_145850_b, this.field_174879_c);
                }
                if (result.isSuccess()) {
                    this.inventory.setStackInSlot(0, result.getResult());
                }
                Fluid freshWater = FluidRegistry.getFluid((String)"fresh_water");
                if (!this.sealed && this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a()) && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == freshWater)) {
                    this.tank.fill(new FluidStack(freshWater, 10), true);
                }
                if (this.inventory.getStackInSlot(2) == ItemStack.field_190927_a && !this.surplus.isEmpty()) {
                    this.inventory.setStackInSlot(2, this.surplus.poll());
                }
            }
            if (this.recipe != null && this.sealed) {
                int durationSealed = (int)(CalendarTFC.PLAYER_TIME.getTicks() - this.sealedTick);
                if (this.recipe.getDuration() > 0 && durationSealed > this.recipe.getDuration()) {
                    ItemStack inputStack = this.inventory.getStackInSlot(2);
                    FluidStack inputFluid = this.tank.getFluid();
                    if (this.recipe.isValidInput(inputFluid, inputStack)) {
                        this.tank.setFluid(this.recipe.getOutputFluid(inputFluid, inputStack));
                        output = this.recipe.getOutputItem(inputFluid, inputStack);
                        first = output.get(0);
                        output.remove(0);
                        this.inventory.setStackInSlot(2, first);
                        this.surplus.addAll(output);
                        this.markForSync();
                        this.onSealed();
                    } else {
                        this.recipe = null;
                    }
                }
            }
            if (this.checkInstantRecipe) {
                FluidStack inputFluid;
                ItemStack inputStack = this.inventory.getStackInSlot(2);
                BarrelRecipe instantRecipe = BarrelRecipe.getInstant(inputStack, inputFluid = this.tank.getFluid());
                if (instantRecipe != null && inputFluid != null && instantRecipe.isValidInputInstant(inputStack, inputFluid)) {
                    this.tank.setFluid(instantRecipe.getOutputFluid(inputFluid, inputStack));
                    output = instantRecipe.getOutputItem(inputFluid, inputStack);
                    first = output.get(0);
                    output.remove(0);
                    this.inventory.setStackInSlot(2, first);
                    this.surplus.addAll(output);
                    instantRecipe.onRecipeComplete(this.field_145850_b, this.field_174879_c);
                    this.markForSync();
                } else {
                    this.checkInstantRecipe = false;
                }
            }
        }
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.checkInstantRecipe = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (fluidStack != null) {
                fluidStack.amount = this.tank.getCapacity();
            }
            this.tank.setFluid(fluidStack);
        }
        this.sealedTick = nbt.func_74763_f("sealedTick");
        this.sealedCalendarTick = nbt.func_74763_f("sealedCalendarTick");
        this.sealed = nbt.func_74767_n("sealed");
        this.lastPlayerTick = nbt.func_74763_f("lastPlayerTick");
        this.surplus.clear();
        if (nbt.func_74764_b("surplus")) {
            NBTTagList surplusItems = nbt.func_150295_c("surplus", 10);
            for (int i = 0; i < surplusItems.func_74745_c(); ++i) {
                this.surplus.add(new ItemStack(surplusItems.func_150305_b(i)));
            }
        }
        this.recipe = BarrelRecipe.get(this.inventory.getStackInSlot(2), this.tank.getFluid());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74772_a("sealedTick", this.sealedTick);
        nbt.func_74772_a("sealedCalendarTick", this.sealedCalendarTick);
        nbt.func_74757_a("sealed", this.sealed);
        nbt.func_74772_a("lastPlayerTick", this.lastPlayerTick);
        if (!this.surplus.isEmpty()) {
            NBTTagList surplusList = new NBTTagList();
            for (ItemStack stack : this.surplus) {
                surplusList.func_74742_a((NBTBase)stack.serializeNBT());
            }
            nbt.func_74782_a("surplus", (NBTBase)surplusList);
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerSided(this, (IFluidHandler)this.tank, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        ItemStack barrelStack = new ItemStack(state.func_177230_c());
        if (((Boolean)state.func_177229_b((IProperty)BlockBarrel.SEALED)).booleanValue()) {
            this.saveToItemStack(barrelStack);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)barrelStack);
        } else {
            int slotsToDrop = this.inventory.getSlots();
            for (int i = 0; i < slotsToDrop; ++i) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(i));
                this.inventory.setStackInSlot(i, new ItemStack(Items.field_190931_a, 0));
            }
            if (!this.surplus.isEmpty()) {
                for (ItemStack surplusToDrop : this.surplus) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)surplusToDrop);
                }
                this.surplus.clear();
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)barrelStack);
        }
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            }
            case 2: {
                IItemSize size = CapabilityItemSize.getIItemSize(stack);
                if (size != null) {
                    return size.getSize(stack).isSmallerThan(Size.HUGE);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onCalendarUpdate(long deltaPlayerTicks) {
        while (deltaPlayerTicks > 0L) {
            long tickFinish;
            deltaPlayerTicks = 0L;
            if (this.recipe == null || !this.sealed || this.recipe.getDuration() <= 0 || (tickFinish = this.sealedTick + (long)this.recipe.getDuration()) > CalendarTFC.PLAYER_TIME.getTicks()) continue;
            deltaPlayerTicks = 1L;
            long offset = tickFinish - CalendarTFC.PLAYER_TIME.getTicks();
            CalendarTFC.runTransaction(offset, offset, () -> {
                ItemStack inputStack = this.inventory.getStackInSlot(2);
                FluidStack inputFluid = this.tank.getFluid();
                if (this.recipe.isValidInput(inputFluid, inputStack)) {
                    this.tank.setFluid(this.recipe.getOutputFluid(inputFluid, inputStack));
                    List<ItemStack> output = this.recipe.getOutputItem(inputFluid, inputStack);
                    ItemStack first = output.get(0);
                    output.remove(0);
                    this.inventory.setStackInSlot(2, first);
                    this.surplus.addAll(output);
                    this.markForSync();
                    this.onSealed();
                } else {
                    this.recipe = null;
                }
            });
        }
    }

    @Override
    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    protected static class BarrelFluidTank
    extends FluidTankCallback {
        private final Set<Fluid> whitelist;

        public BarrelFluidTank(IFluidTankCallback callback, int fluidTankID) {
            super(callback, fluidTankID, ConfigTFC.Devices.BARREL.tank);
            this.whitelist = Arrays.stream(ConfigTFC.Devices.BARREL.fluidWhitelist).map(FluidRegistry::getFluid).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && (this.whitelist.contains(fluid.getFluid()) || BarrelRecipe.isBarrelFluid(fluid));
        }
    }
}

